/* 
 *  RefClientProperties.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import java.io.InputStream;
import java.util.Properties;

public class RefClientProperties {
    
    private static final Logger LOG = Logger.getLogger(RefClientProperties.class);
    private static final String FILENAME = "JavaFXRefClient.properties";
    private static final String USERNAME = "domain\\username";
    private static final String PASSWORD = "password";
    private static final String SERVER = "servername";


    public ConnectionDetails getConnectionDetails() {
        String methodName = "getConnectionDetails()";
        ConnectionDetails connectionDetails;
        try (InputStream inputStream = getClass().getClassLoader().getResourceAsStream(FILENAME)) {
            Properties prop = new Properties();            

            if (inputStream != null) {
                prop.load(inputStream);
            } else {
                LOG.warn(methodName + " failed to read connection details from prop file, using defaults");
                return new ConnectionDetails(USERNAME, PASSWORD, SERVER, true);
            }

            String username = prop.getProperty("username", USERNAME);
            String password = prop.getProperty("password", PASSWORD);
            String server = prop.getProperty("server", SERVER);
    
            String autoreconnect = prop.getProperty("autoreconnect");
            boolean autoReconnectBoolean = true;
            if (autoreconnect != null) {
                autoReconnectBoolean = Boolean.parseBoolean(autoreconnect);
            }
            connectionDetails = new ConnectionDetails(username, password, server, autoReconnectBoolean);
            LOG.trace(methodName + " username=" + username + " password chars=" + password.length() + " server=" + server + " autoreconnect=" + autoreconnect);
        } catch (Exception e) {
            LOG.warn(methodName + " failed to read connection details from prop file, using defaults" + e);
            return new ConnectionDetails(USERNAME, PASSWORD, SERVER, true);
        } 
        return connectionDetails;
    }
}
